(() => {
	const { focusTrap } = window;
	
	/**
	 *
	 * @type {OverlayElement[]}
	 */
	const overlayElements = [];
	class OverlayElement {
		constructor(el, closeFn) {
			this.el = el;
			this.closeFn = closeFn;
		}
	}
	
	window.addEventListener('keyup', e => {
		if (e.key === 'Escape' && overlayElements.length) {
			const mostRecentOpenOverlay = overlayElements[overlayElements.length - 1];
			mostRecentOpenOverlay.closeFn();
		}
	});
	
	window.overlayManager = {
		add(el, closeFn) {
			overlayElements.push(new OverlayElement(el, closeFn));
			
			const trap = this.createFocusTrap(el);
			el._focusTrap = trap;
			trap.activate();
			
			// Unfocus any actively focused element.
			// document.activeElement.blur() will not work for all custom elements.
			const input = Object.assign(document.createElement('input'), {
				style: 'position: fixed; width: 0; height: 0;',
			});
			document.body.append(input);
			input.focus();
			input.blur();
			input.remove();
			
			// Prevent the body (which is now in the background) from scrolling.
			document.body.style.overflow = 'hidden';
			document.body.style.userSelect = 'none';
		},
		remove(el) {
			el._focusTrap?.deactivate();
			
			const index = overlayElements.findIndex(i => i.el === el);
			if (index > -1) {
				overlayElements.splice(index, 1);
			}
			
			if (!overlayElements.length) {
				document.body.style.overflow = '';
				document.body.style.userSelect = '';
			}
		},
		createFocusTrap(el) {
			return focusTrap.createFocusTrap(el, {
				// Fixes edge case where creating this focus trap causes elements added later to the element to not be
				// interactable, probably because the focus trap doesn't account for newly-added elements.
				allowOutsideClick: true,
				
				// Focus is not trapped if the element contains no tabbable elements.
				fallbackFocus: el,
				
				// If the first focus-able element is off-screen, the element will be scrolled down to that element,
				// which is undesirable.
				initialFocus: false,
				
				tabbableOptions: {
					// Account for elements in descendant shadow roots.
					getShadowRoot: true,
				},
			});
		},
	}
})();