(() => {
    const { RentecLitElement, lit } = window;
    const { html, css } = lit;

    (class RentecFormErrorComponent extends RentecLitElement {
        static properties = {
            ...super.properties,
            reversed: { type: Boolean },
        }
        
        static styles = [
            super.styles,
            css`
                .container {
                    display: flex;
                    align-items: start;
                    gap: var(--space-1);
                    color: var(--color-fg-danger);
                    font-size: var(--fs-f5);
                    line-height: var(--fs-f5-lh);
                    min-width: 100%;
                    max-width: min-content;
                }
                .icon-container {
                    display: flex;
                    align-items: center;
                    height: var(--fs-f5-lh);
                }
                .icon {
                    width: var(--space-4);
                    height: var(--space-4);
                    flex-shrink: 0;
                }
                .text {
                    word-break: break-word;
                }
            `
        ]

        render() {
            return html`
                <div class="container" part="container">
                    <div class="icon-container">
                        <r-icon class="icon" name="alert" part="icon"></r-icon>
                    </div>
                    
                    <div class="text">
                        <slot></slot>
                    </div>
                </div>
            `;
        }
    }).define('r-form-error');
})();
