(() => {
    const { RentecLitElement, lit } = window;
    const { html, css } = lit;

    (class RentecLoadingComponent extends RentecLitElement {
        static styles = [
            super.styles,
            css`
                :host {
                    --track-width: var(--space-1);
                    width: var(--space-8);
                    height: var(--space-8);
                    color: var(--color-primary);
                }
                
                .loading {
                    border: var(--track-width) solid rgba(0, 0, 0, 0);
                    border-top: var(--track-width) solid currentColor;
                    border-radius: 50%;
                    width: 100%;
                    height: 100%;
                    animation: spin 2s linear infinite;
                }
                
                @keyframes spin {
                    0% {
                        transform: rotate(0deg);
                    }
                    100% {
                        transform: rotate(360deg);
                    }
                }
            `,
        ]

        render() {
            return html`
                <div class="loading"></div>
            `;
        }
    }).define('r-loading');
})();
