'use strict';
window.rentecCssUtils = {
	/**
	 * Returns the href of a fetched stylesheet on the page.
	 * Allows ability to reference already-fetched CSS files to prevent CSS files from being fetched again.
	 * Sometimes initially-fetched CSS files come with a "hash" in their href, and if a part of the application needs to ref
	 * the stylesheet after this initial fetch, the browser will try to look for the file without the hash in its href but
	 * will not find the file in the list of files it has already fetched.
	 * If the stylesheet hasn't been fetched yet, return what should be the href of the CSS file.
	 * @param stylesheetName {String}
	 * @returns {String} - the href of the stylesheet
	 */
	css(stylesheetName) {
		// document.styleSheets may not account for all of a page's stylesheets when it is invoked (e.g. deferred stylesheets may not yet be present).
		const stylesheets = document.querySelectorAll('head > link');
		for (let i=0; i<stylesheets.length; i++) {
			const stylesheet = stylesheets[i];
			const regExStr = `/(${stylesheetName})\.css`;
			const regEx = new RegExp(regExStr, 'g');
			if (stylesheet.href && stylesheet.href.match(regEx)) {
				return stylesheet.href;
			}
		}
		console.warn(`Stylesheet "${stylesheetName}.css" is missing from the DOM - attempting to fetch stylesheet.`);
		return `./css/${stylesheetName}.css`;
	}
}
